#!/bin/bash
# Copyright 2019 by Vision Components GmbH, MBE


SUCCESS="[$(tput bold)Success$(tput sgr0)]"
FAILURE="[$(tput bold)Failure$(tput sgr0)]"

################################################################################
echo ----------------------
echo

cmaState=$(dmesg | grep '^[^]]*\] Memory:')
cmaSizeK=$(echo $cmaState | sed 's/.* \([0-9]\+\)K cma-reserved.*/\1/')

if [[ $(echo $cmaState | grep 'cma-reserved') ]] && [ "$cmaSizeK" -gt "128000" ]; then
	RESULT="$SUCCESS"
else
	RESULT="$FAILURE"
fi 
echo "$RESULT  Reserve memory for image acquisition (cma=128M @ /boot/cmdline.txt):"
echo
echo "$cmaState"
echo
################################################################################
echo ----------------------
echo

overlayState=$(sudo vcdbg log msg  2>&1 | grep '^[0-9\.]\+: Loaded overlay')

if [[ $(echo $overlayState | grep 'vc_mipi_imx290') ]] ; then
	RESULT="$SUCCESS"
else
	RESULT="$FAILURE"
fi 
echo "$RESULT  Load kernel device tree overlay (dtoverlay=vc_mipi_imx290 @ /boot/config.txt):"
echo
echo "$overlayState"
echo
################################################################################
echo ----------------------
echo

dtparamState=$(sudo vcdbg log msg  2>&1 | grep '^[0-9\.]\+: dtparam:')

if [[ $(echo $dtparamState | grep 'i2c_vc=on') ]] ; then
	RESULT="$SUCCESS"
else
	RESULT="$FAILURE"
fi 
echo "$RESULT  Active I2C sensor communication (dtparam=i2c_vc=on @ /boot/config.txt):"
echo
echo "$dtparamState"
echo
################################################################################
echo ----------------------
echo

platformDriverState=$(dmesg | grep '^[^]]*\] bcm2835[_-]unicam')


if [ -n "$platformDriverState" ] && ! [[ $(echo $platformDriverState | grep -i '\(fail\|error\)') ]] ; then
	RESULT="$SUCCESS"
else
	RESULT="$FAILURE"
fi 
echo "$RESULT  Load platform driver without error (modprobe bcm2835-unicam):"
echo
echo "$platformDriverState"
echo
################################################################################
echo ----------------------
echo

sensorDriverState=$(dmesg | grep '^[^]]*\] vc_mipi_imx290')


if [ -n "$sensorDriverState" ] && ! [[ $(echo $sensorDriverState | grep -i '\(fail\|error\)') ]] ; then
	RESULT="$SUCCESS"
else
	RESULT="$FAILURE"
fi 
echo "$RESULT  Load sensor driver without error (modprobe vc_mipi_imx290):"
echo
echo "$sensorDriverState"
echo
################################################################################


